/**
 * LLMS Central Bot Tracker - Admin JavaScript
 */

(function($) {
    'use strict';
    
    $(document).ready(function() {
        // Tab switching
        $('.nav-tab').on('click', function(e) {
            e.preventDefault();
            
            var target = $(this).attr('href');
            
            // Update tabs
            $('.nav-tab').removeClass('nav-tab-active');
            $(this).addClass('nav-tab-active');
            
            // Update content
            $('.tab-content').removeClass('active');
            $(target).addClass('active');
        });
        
        // Show warning when disabling tracking
        $('input[name="llmscbt_tracking_enabled"]').on('change', function() {
            if (!$(this).is(':checked')) {
                if (!confirm('Are you sure you want to disable AI bot tracking? You will no longer receive analytics data.')) {
                    $(this).prop('checked', true);
                }
            }
        });
        
        // Show warning when disabling llms.txt
        $('input[name="llmscbt_llms_txt_enabled"]').on('change', function() {
            if (!$(this).is(':checked')) {
                if (!confirm('Are you sure you want to disable llms.txt? Your AI training guidelines will no longer be accessible.')) {
                    $(this).prop('checked', true);
                }
            }
        });
        
        // Validate consent checkbox
        $('form').on('submit', function(e) {
            var trackingEnabled = $('input[name="llmscbt_tracking_enabled"]').is(':checked');
            var consentGiven = $('input[name="llmscbt_consent_given"]').is(':checked');
            
            if (trackingEnabled && !consentGiven) {
                e.preventDefault();
                alert('Please review and accept the privacy policy to enable tracking.');
                $('.nav-tab[href="#privacy"]').click();
                return false;
            }
        });
    });
    
})(jQuery);
