<?php
/**
 * llms.txt File Handler
 */

// Exit if accessed directly
if (!defined('ABSPATH')) {
    exit;
}

class LLMSCBT_LLMS_TXT {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (null === self::$instance) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        add_action('init', array($this, 'add_rewrite_rule'));
        add_action('template_redirect', array($this, 'serve_llms_txt'));
    }
    
    /**
     * Add rewrite rule for llms.txt
     */
    public function add_rewrite_rule() {
        add_rewrite_rule('^llms\.txt$', 'index.php?llms_txt=1', 'top');
        add_rewrite_tag('%llms_txt%', '([^&]+)');
    }
    
    /**
     * Serve llms.txt file
     */
    public function serve_llms_txt() {
        if (!get_query_var('llms_txt')) {
            return;
        }
        
        if (!get_option('llmscbt_llms_txt_enabled')) {
            status_header(404);
            return;
        }
        
        $content = get_option('llmscbt_llms_txt_content', '');
        
        if (empty($content)) {
            status_header(404);
            return;
        }
        
        // Set headers
        header('Content-Type: text/plain; charset=utf-8');
        header('Cache-Control: public, max-age=3600');
        header('X-Robots-Tag: noindex');
        
        // Output content (already sanitized on save with sanitize_textarea_field)
        echo $content;
        exit;
    }
}
