<?php
/**
 * Uninstall Script
 * 
 * Fired when the plugin is uninstalled (deleted, not just deactivated)
 */

// Exit if accessed directly or not uninstalling
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete all plugin options
delete_option('llmscbt_tracking_enabled');
delete_option('llmscbt_domain');
delete_option('llmscbt_llms_txt_enabled');
delete_option('llmscbt_llms_txt_content');
delete_option('llmscbt_consent_given');

// Remove llms.txt file if it exists
$llms_txt_file = ABSPATH . 'llms.txt';
if (file_exists($llms_txt_file)) {
    unlink($llms_txt_file);
}

// Clear any cached data
wp_cache_flush();
